/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import projectvibrantjourneys.init.object.PVJBlocks;
import projectvibrantjourneys.init.world.PVJBlockPlacers;

public class AspenTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<AspenTrunkPlacer> CODEC = RecordCodecBuilder.create(x -> AspenTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)x).apply((Applicative)x, AspenTrunkPlacer::new));

    public AspenTrunkPlacer(int baseHeight, int heightA, int heightB) {
        super(baseHeight, heightA, heightB);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return PVJBlockPlacers.ASPEN_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int height, BlockPos pos, Set<BlockPos> blocks, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        AspenTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)pos.func_177977_b());
        ArrayList list = Lists.newArrayList();
        BlockPos.Mutable blockpos = pos.func_239590_i_();
        int trunkHeight = 6 + rand.nextInt(2);
        for (int i = 0; i < height; ++i) {
            AspenTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177981_b(i), blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
            if (i < trunkHeight) continue;
            list.add(new FoliagePlacer.Foliage(blockpos.func_177981_b(i), 0, false));
            if (i % 2 != 0 || i >= height - 2) continue;
            for (Direction dir : Direction.values()) {
                if (!dir.func_176740_k().func_176722_c()) continue;
                int length = 1 + height / i;
                BlockPos.Mutable branchPos = blockpos.func_177981_b(i).func_239590_i_();
                for (int j = 0; j < length; ++j) {
                    if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)branchPos.func_177971_a(dir.func_176730_m()))) {
                        branchPos = branchPos.func_177971_a(dir.func_176730_m()).func_239590_i_();
                        AspenTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)branchPos, (BlockState)((BlockState)PVJBlocks.aspen_log.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)dir.func_176740_k())), (MutableBoundingBox)box);
                        blocks.add(branchPos.func_185334_h());
                    }
                    list.add(new FoliagePlacer.Foliage((BlockPos)branchPos, 0, false));
                }
                list.add(new FoliagePlacer.Foliage(branchPos.func_177971_a(dir.func_176730_m()), 0, false));
            }
        }
        list.add(new FoliagePlacer.Foliage(blockpos.func_177981_b(height), 0, false));
        return list;
    }
}

